;-- Simple code to illustrate the use of an external app to control an SCL simulation. --
;    No contact debouncing is done. A-D Channel selection is not done - it would have 
;    no effect on the simulation
;
;	The program and testbench simulate a 4 x 4 matrix connected to PORTB as follows:
;
;                                    o--o--o--o------ Vcc
;                                    |  |  |  |
;                                    |  |  |  |
;                                   | || || || |
;          Pullup resistors   --->  | || || || |
;          attached to RB4..RB7     | || || || |
;                                    |  |  |  |
;        +---------------------------o--+--+--+----- RB4
;        |                              |  |  |
;        |       +----------------------o--+--+----- RB5
;        |       |                         |  |
;        |       |       +-----------------o--+----- RB6
;        |       |       |                    |
;        |       |       |       +------------o----- RB7
;        |       |       |       |
;       [0]-----[1]-----[2]-----[3]----------------- RB0
;        |       |       |       |
;       [4]-----[5]-----[6]-----[7]----------------- RB1
;        |       |       |       |
;       [8]-----[9]-----[A]-----[B]----------------- RB2
;        |       |       |       |
;       [C]-----[D]-----[E]-----[F]----------------- RB3
;


	processor 16F88

	include p16f88.inc

 #define bank0 h'00'
 #define bank1 h'80'

 cblock h'20'
	AD_Res16:0, ResLo, ResHi	;16 bit variable used to store conversion result.
	RowMsk				;Mask used in determining which row is selected 
	Temp					
	KeyTemp				;Using a temp variable makes viewing of KeyCode easier while
	KeyCode				; running at full speed - only view final result.
 endc

	org	0
;-----------------------------------------
Start:			call	Init	

Main: 			clrwdt
			call	Convert
			call	ScanKey
	
			goto	Main

;---[ Convert ]----------------------------
;Returns a 10 bit result in Res16
Convert:		bsf		ADCON0, GO
AD_Loop:		btfsc	ADCON0, NOT_DONE
			goto	AD_Loop

			banksel	bank1
			movf	ADRESL, W 
			banksel	bank0
			movwf	ResLo
			movf	ADRESH, W
			movwf	ResHi
			return

;---[ ScanKey ]---------------------------
;Scan PORTB, and update KeyCode according to which key is pressed.
ScanKey:		movlw	h'FE'
			movwf	RowMsk
			clrf	KeyTemp
			movlw	4
			movwf	Temp

ScanNextRow:		movf	RowMsk, W	
			movwf	PORTB
			nop
			nop
			swapf	PORTB, W
			andlw	h'0F'
			xorlw	h'0F'
			skpz
			goto	RowFound
			movlw	4
			addwf	KeyTemp, F
			setc
			rlf	RowMsk, F
			decfsz	Temp, F
			goto	ScanNextRow
NoKey:			movlw	h'FF'
			movwf	KeyCode
			return

RowFound:		; At this point W should contain 1,2,4 or 8 - Add 0,1,2 or 3 respectivly
			movwf	Temp
			clrc
			rrf		Temp, W
			btfsc	Temp, 3
			addlw	-1
			addwf	KeyTemp, W
			movwf	KeyCode
			return

;---[ Init ]------------------------------
Init:			
			banksel	bank1
			movlw	0xF0
			movwf	TRISB
			movlw	b'11000000'
			movwf	ADCON1
			movlw	b'00000001'
			movwf	ANSEL
			banksel	bank0
			movlw	b'01000001'
			movwf	ADCON0
			movlw	0xFF
			movwf	PORTB
			return

			end				
